/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers.reprap;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import replicatorg.app.Base;
import replicatorg.drivers.reprap.RepRap5DDriver;

public class ExtrusionUpdater {
    private final RepRap5DDriver driver;
    public final AtomicBoolean isExtruding = new AtomicBoolean(false);
    private ReentrantLock feedrateLock = new ReentrantLock();
    private double feedrate = 0.0;
    private ReentrantLock directionLock = new ReentrantLock();
    private Direction direction = Direction.forward;
    private long extrudeQueueEnd = 0L;
    private long commandPeriod = 100L;
    private int maxQueuedExtrudeTime = 200;

    public ExtrusionUpdater(RepRap5DDriver driver) {
        this.driver = driver;
    }

    private void determineCommandPeriod() {
        double motorSteps = this.driver.getMotorSteps();
        if (motorSteps == 0.0) {
            motorSteps = 200.0;
        }
        Base.logger.info("motorSteps=" + motorSteps);
        this.commandPeriod = (long)(motorSteps / 2.0);
        Base.logger.info("commandPeriod=" + this.commandPeriod);
    }

    private void sendExtrudeCommand(double distance, double feedrate) {
        this.determineCommandPeriod();
        String feedrateString = this.driver.df.format(feedrate);
        if (this.driver.feedrate.get() != feedrate) {
            this.driver.sendCommand(String.valueOf(this.driver._getToolCode()) + "G1 F" + feedrateString);
        }
        this.driver.sendCommand(String.valueOf(this.driver._getToolCode()) + "G1 E" + this.driver.df.format(distance + this.driver.ePosition.get()) + " F" + feedrateString);
    }

    public void setFeedrate(double feedrate) {
        this.feedrateLock.lock();
        this.feedrate = feedrate;
        this.feedrateLock.unlock();
    }

    private double getFeedrate() {
        this.feedrateLock.lock();
        double f = this.feedrate;
        this.feedrateLock.unlock();
        this.directionLock.lock();
        int n = this.direction == Direction.forward ? 1 : -1;
        this.directionLock.unlock();
        return f *= (double)n;
    }

    public void setDirection(Direction direction) {
        this.directionLock.lock();
        this.direction = direction;
        this.directionLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws InterruptedException {
        if (this.isExtruding.get()) {
            int queueSize;
            long currentTime = System.currentTimeMillis();
            if (this.extrudeQueueEnd > currentTime + (long)this.maxQueuedExtrudeTime) {
                Thread.sleep(this.extrudeQueueEnd - currentTime);
            }
            do {
                if ((queueSize = this.driver.queueSize()) <= this.maxQueuedExtrudeTime) continue;
                Thread.sleep(100L);
            } while (queueSize > this.maxQueuedExtrudeTime);
            double feedrate = this.getFeedrate();
            if (feedrate == 0.0) {
                return;
            }
            double distance = feedrate * (double)this.commandPeriod / 60000.0;
            RepRap5DDriver repRap5DDriver = this.driver;
            synchronized (repRap5DDriver) {
                this.extrudeQueueEnd = this.extrudeQueueEnd < System.currentTimeMillis() ? System.currentTimeMillis() + this.commandPeriod : (this.extrudeQueueEnd += this.commandPeriod);
                this.sendExtrudeCommand(distance, Math.abs(feedrate));
            }
        } else {
            Thread.sleep(100L);
        }
    }

    public void startExtruding() {
        this.isExtruding.set(true);
    }

    public void stopExtruding() {
        this.isExtruding.set(false);
    }

    public static enum Direction {
        forward,
        reverse;

    }
}

